//---------------------------------------------------------------------------
#ifndef froslina6H
#define froslina6H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <stdlib.h>

const double NIEOKRESLONY = -9999999;   //dla parametrw TGen::min, max
//---------------------------------------------------------------------------
//  Parametr roliny (kt, dugo, kolor, co tam jeszcze),
//  z wbudowanym procesem modyfikacji na szeroko +/- mutacja.
class TGen
{
 private:
    double g;               //warto genu (kt, dugo, kolor, ...)
    double mutacja;         //szeroko mutacji
    double min, max;        //zakres dopuszczalnych wartoci
    double mutuj( double Ag, double Amut, double Amin, double Amax) const;
 public:
    TGen( double Ag,        //konstruktor merytoryczny
          double Amutacja,
          double Amin=NIEOKRESLONY, double Amax=NIEOKRESLONY);
    double daj_zmutowany_parametr( void) const; //funkcje odczytu genu
    TColor daj_zmutowany_kolor( void) const;
    void   daj_min_max( double &Amin, double &Amax) const;
    void   daj_mut( double &Amut) const;
};
//---------------------------------------------------------------------------
class TForm1 : public TForm
{
__published:
    void __fastcall FormPaint(TObject *Sender);
private:
    String formula;
    int POZYCJA;
    void rozwin( void);
    void rysuj( double Ax0, double Ay0,
                TGen Adlg, TGen Agrub, TGen Akolor,
                TGen Bdlg, TGen Bgrub, TGen Bkolor, TGen Zmianadlg,
                TGen Kierunek, TGen Lzakret, TGen RZakret,
                TGen Odrost);
public:
    __fastcall TForm1(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
